<?php
/*
Plugin Name: Physcode - Visual Composer Addon
Plugin URI: http://physcode.com
Description: Shortcode extend of Visual Composer
Version: 1.0.2
Author: Physcode(info@physcode.com)
Author URI: http://physcode.com
Copyright 2014-2015 physcode.com. All rights reserved.
 * Text Domain: physc-vc-addon
 * Domain Path: /languages/
*/

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}


if ( !defined( 'PHYSC_VC_ADDON_PLUGIN_URL' ) ) {
	define( 'PHYSC_VC_ADDON_PLUGIN_URL', untrailingslashit( plugins_url( '/', __FILE__ ) ) );
}
if ( !defined( 'PHYSC_VC_ADDON_PATH' ) ) {
	define( 'PHYSC_VC_ADDON_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
}

if ( !function_exists( 'Register_Physcode_Vc_Addon' ) ) {
	function Register_Physcode_Vc_Addon( $prefix, $args ) {
		if ( is_array( $args ) ) {
			for ( $i = 0; $i < count( $args ); $i ++ ) {
				if ( $args[$i] <> '' ) {
					add_shortcode( $args[$i], $prefix . '_shortcode_' . $args[$i] );
				}
			}
		}
	}
}

if ( !class_exists( 'Physc_Vc_Addon' ) ) {
	class Physc_Vc_Addon {
		/**
		 * @var string
		 * @since 1.0
		 */

		/**
		 * @var object The single instance of the class
		 * @since 1.0
		 */


		protected static $_instance = null;

		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		public function __construct() {
			self::init();

			add_action( 'admin_enqueue_scripts', array( $this, 'Physc_scriptInitAdmin' ) );
			add_filter( 'the_content', array( $this, 'physcode_shortcodes_formatter' ) );
			add_filter( 'widget_text', array( $this, 'physcode_shortcodes_formatter' ) );
			if ( function_exists( 'vc_add_shortcode_param' ) ) {
				vc_add_shortcode_param( 'datepicker', array( $this, 'Physc_datepicker_field' ), PHYSC_VC_ADDON_PLUGIN_URL . '/js/datepicker.js' );
				vc_add_shortcode_param( 'number', array( $this, 'Physc_number_settings_field' ) );
				vc_add_shortcode_param( 'radioimage', array( $this, 'Physc_radioimage_settings_field' ) );
				vc_add_shortcode_param( 'multi_dropdown', array( $this, 'Physc_multi_dropdown_settings_field' ) );
			}
		}

		protected function init() {
			$this->load_plugin_textdomain();
			require_once PHYSC_VC_ADDON_PATH . '/inc/importer/radium-importer.php'; //load admin theme data importer
			require_once PHYSC_VC_ADDON_PATH . '/inc/post-likes.php';
			require_once PHYSC_VC_ADDON_PATH . '/inc/post-views.php';
		}

		public function Physc_scriptInitAdmin() {
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_style( 'jquery-style', '//ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css' );
		}


		public function Physc_radioimage_settings_field( $settings, $value ) {
			$dependency = vc_map_integrate_add_dependency( $settings, $value );
			$param_name = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
			$type       = isset( $settings['type'] ) ? $settings['type'] : '';
			$radios     = isset( $settings['options'] ) ? $settings['options'] : '';
			$class      = isset( $settings['class'] ) ? $settings['class'] : '';
			$output     = '<input type="hidden" name="' . $param_name . '" id="' . $param_name . '" class="wpb_vc_param_value ' . $param_name . ' ' . $type . '_field ' . $class . '" value="' . $value . '" ' . $dependency . ' />';
			$output     .= '<div id="' . $param_name . '_wrap" class="icon_style_wrap ' . $class . '" >';
			if ( $radios != '' && is_array( $radios ) ) {
				$i = 0;
				foreach ( $radios as $key => $image_url ) {
					$class   = ( $key == $value ) ? ' class="selected" ' : '';
					$image   = '<img id="' . $param_name . $i . '_img' . $key . '" src="' . $image_url . '" ' . $class . '/>';
					$checked = ( $key == $value ) ? ' checked="checked" ' : '';
					$image   .= '<input name="' . $param_name . '_option" id="' . $param_name . $i . '" value="' . $key . '" type="radio" '
						. 'onchange="document.getElementById(\'' . $param_name . '\').value=this.value;'
						. 'jQuery(\'#' . $param_name . '_wrap img\').removeClass(\'selected\');'
						. 'jQuery(\'#' . $param_name . $i . '_img' . $key . '\').addClass(\'selected\');" '
						. $checked . ' style="display:none;" />';
					$output  .= '<label for="' . $param_name . $i . '">' . $image . '</label>';
					$i ++;
				}
			}
			$output .= '</div>';

			return $output;
		}

		public function Physc_datepicker_field( $settings, $value ) {
			$value  = (string) $value;
			$output = '<div class="date_param_block">'
				. '<input name="' . esc_attr( $settings['param_name'] ) . '" class="vc_param_datepicker wpb_vc_param_value wpb-textinput ' .
				esc_attr( $settings['param_name'] ) . ' ' .
				esc_attr( $settings['type'] ) . '_field" type="text" value="' . esc_attr( $value ) . '" />'
				. '</div>';

			return $output;
		}

		// Function generate param type "number"
		public function Physc_number_settings_field( $settings, $value ) {
			$dependency = vc_map_integrate_add_dependency( $settings, $value );
			$param_name = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
			$type       = isset( $settings['type'] ) ? $settings['type'] : '';
			$min        = isset( $settings['min'] ) ? $settings['min'] : '';
			$max        = isset( $settings['max'] ) ? $settings['max'] : '';
			$suffix     = isset( $settings['suffix'] ) ? $settings['suffix'] : '';
			$class      = isset( $settings['class'] ) ? $settings['class'] : '';
			$output     = '<input type="number" min="' . $min . '" max="' . $max . '" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="' . $value . '" style="max-width:100px; margin-right: 10px;" ' . $dependency . '/>' . $suffix;

			return $output;
		}

		/**
		 * Add multi select field
		 */

		public function Physc_multi_dropdown_settings_field( $settings, $value ) {
			if ( !is_array( $value ) ) {
				$value = $value ? $value : '';
				$value = array_filter( explode( ',', $value ) );
			}
			$output = '<div class="multi_dropdown_block">';

			$output .= '<select name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-input wpb-select ' . esc_attr( $settings['param_name'] ) . ' ' .
				esc_attr( $settings['type'] ) . '_field" multiple="multiple">';

			if ( !empty( $settings['value'] ) ) {
				foreach ( $settings['value'] as $index => $data ) {
					if ( is_numeric( $index ) && ( is_string( $data ) || is_numeric( $data ) ) ) {
						$option_label = $data;
						$option_value = $data;
					} elseif ( is_numeric( $index ) && is_array( $data ) ) {
						$option_label = isset( $data['label'] ) ? $data['label'] : array_pop( $data );
						$option_value = isset( $data['value'] ) ? $data['value'] : array_pop( $data );
					} else {
						$option_value = $data;
						$option_label = $index;
					}
					$selected            = '';
					$option_value_string = (string) $option_value;
					$value_string        = $value;
					if ( '' !== $value && in_array( $option_value_string, $value_string ) ) {
						$selected = ' selected="selected"';
					}
					$option_class = str_replace( '#', 'hash-', $option_value );
					$output       .= '<option class="' . esc_attr( $option_class ) . '" value="' . esc_attr( $option_value ) . '"' . $selected . '>'
						. htmlspecialchars( $option_label ) . '</option>';
				}
			}
			$output .= '</select>';
			$output .= '</div>';

			return $output;
		}


		//////////////////////////////////////////////////////////////////
		// Remove extra P tags
		//////////////////////////////////////////////////////////////////
		public function physcode_shortcodes_formatter( $content ) {
			$block = join( "|", array( "phys_custom_html" ) );
			// opening tag
			$rep = preg_replace( "/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/", "[$2$3]", $content );
			// closing tag
			$rep = preg_replace( "/(<p>)?\[\/($block)](<\/p>|<br \/>)/", "[/$2]", $rep );

			return $rep;
		}

		public function load_plugin_textdomain() {
			$locale = apply_filters( 'plugin_locale', get_locale(), 'physc-vc-addon' );
			load_textdomain( 'physc-vc-addon', WP_LANG_DIR . '/physc-vc-addon/physc-vc-addon-' . $locale . '.mo' );
			load_plugin_textdomain( 'physc-vc-addon', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );
		}
	}
}
$Physc_Vc_Addon = Physc_Vc_Addon::instance();